rm(list=ls(all=TRUE))
#--------------------------------------------------------------------------------------------------
## carregando alguns pacotes necessrios para a anlise geoestatistica
require(sp); require(geoR); require(lattice)
require(maptools); require(MASS); require(rgdal)
#--------------------------------------------------------------------------------------------------
  #----------------------------------------#
  #   VARIAVEL: precipitao (4 COLUNA)    #
  #----------------------------------------#
setwd("C:/rotinas02")  # redirecionando o diretrio 
dir()
#--------------------------------------------------------------------------------------------------
## carregando a borda do estado de Minas Gerais (MG)
mgbutm   <- read.table("MG-bor-utm.txt", head=T)
mgbutm.t <- mgbutm
mgbutm.t$X1 <- mgbutm.t$X1+200000 # Transladando a rea para trabalhar
head(mgbutm);head(mgbutm.t)       # dentro de um s fuso (coordenadas positivas)

# reduzindo as coodenadas, agiliza o tempo de estimao dos parmetros no R  
mgbutm.t2<-mgbutm.t
mgbutm.t2$X1<-(mgbutm.t$X1)/10000 # A escala agora ser 1:10000m
mgbutm.t3<-mgbutm.t2
mgbutm.t3$X2<-(mgbutm.t2$X2)/10000 #A escala agora ser 1:10000m
head(mgbutm.t3); head(mgbutm.t)
ls()
#--------------------------------------------------------------------------------------------------
file.show("MG-dat-utm.txt") # todo o conjunto em unidades de utm
dados.o  <- read.table("MG-dat-utm.txt", sep="", head=T)
dados.t  <- dados.o
dados.t$X <- dados.t$X+200000  # Transladando para ficar dentro de um so fuso
head(dados.o);head(dados.t);length(dados.t$CHUVA)

boxplot(dados.t$CHUVA)  # pontos discrepantes
hist(dados.t$CHUVA) 
shapiro.test(dados.t$CHUVA)

dados.t[which(dados.t$CHUVA < 600 | dados.t$CHUVA > 2100),] ## outliers!
dados.t2 <- dados.t[which(dados.t$CHUVA > 600 & dados.t$CHUVA < 2100),]
length(dados.t2$CHUVA)  # removeu-se os outilier
#--------------------------------------------------------------------------------------------------
## visualizao dos dados
boxplot(dados.t2$CHUVA, ylab = "Precipitao mdia anual (mm) em MG (1980-2010)") ## sem outliers!
hist(dados.t2$CHUVA, xlab = "Precipitao", ylab = "Frequncia (mm)")
shapiro.test(dados.t2$CHUVA)
CV= (sqrt(var(dados.t2$CHUVA))*100)/mean(dados.t2$CHUVA); CV
#--------------------------------------------------------------------------------------------------
#Dividindo LONG e LAT pela mesma cst=10000, agilizar o tempo de estimao dos parmetros
dados.t3<- dados.t2
dados.t3$X <- (dados.t2$X)/10000
dados.t4<- dados.t3
dados.t4$Y <- (dados.t3$Y)/10000
head(dados.t4);head(dados.t2)
#--------------------------------------------------------------------------------------------------
dG <- as.geodata(dados.t4, coords.col=c(1,2), data.col=4, covar.col=6 )
dG$borders <- mgbutm.t3
plot(dG)
#--------------------------------------------------------------------------------------------------
## Anlise descritiva dos dados
resumo <- summary(dG); resumo$coords.summary
maiord <- resumo$distances.summary[2];maiord
dist1  <- maiord*.6; dist1 # distancia recomendada
resumo$covariate.summary
#--------------------------------------------------------------------------------------------------
plot(dG, low=T)
plot(dG, low=T, trend=~I(coords[,2]))      # y
plot(dG, low=T, trend=~ALT)                # z
plot(dG, low=T, trend=~I(coords[,2])+ALT)  # y + z
plot(dG, low=T, trend="1st")               # x + y
plot(dG, low=T, trend=~coords+ALT)         # x + y + z
plot(dG, low=T, trend=~coords+I(coords[,1]^2)+I(coords[,2]^2)) # x + y + x^2 + y^2
plot(dG, low=T, trend="2nd")               # x + y + x^2 + y^2 +xy
plot(dG, low=T, trend=~coords+I(coords[,1]^2)+I(coords[,2]^2)+ALT) # x + y + x^2 + y^2 + z
#--------------------------------------------------------------------------------------------------
# Relao entre precipitao e as coordenada geogrficas.
x <- dG$coords[,1]
y <- dG$coords[,2]
plot(x,dG$data, xlab="longitude: x*10.000",ylab = "Precipitao (mm)" )
x11()
plot(y,dG$data, xlab="latitude: y*10.000",ylab = "Precipitao (mm)" )
#--------------------------------------------------------------------------------------------------
#Grfico de crculos, dividido nos quartis
points(dG)
points(dG, pt.div="quarti", cex.min=1, cex.max=1, xlab="x*10.000", ylab="y*10.000")
legend(8,770,c("Min-Q1","Q1-Q2","Q2-Q3","Q3-Mx"),fill=c("blue","green","yellow","red"))
with( parent.frame(dG$coords), identify(dG$coords[,1],dG$coords[,2])) # identificar algum outiliers spaciais
#  156 73 328
dG$data[1]   # Abadia dos Dourados
dG$data[156] # Francisco SA
dG$data[328] # So Joo da Vereda
dG$data[101] # Delfim Moreira
dG$data[23]  # Bairro Santa Cruz
#--------------------------------------------------------------------------------------
## Semi-variograma 
resumo <- summary(dG); resumo$coords.summary
resumo$covariate.summary
maiord <- resumo$distances.summary[2];maiord
dist1  <- maiord*.6; dist1 # sugesto da distncia

dist2  <- 50 # distncia escolhida
plot(v1 <- variog(dG, max.dist=dist2, trend="1st"), xlab="(distncia)*10.000")
plot(v2 <- variog(dG, max.dist=dist2, trend=~coords+ALT), xlab="(distncia)*10.000")
plot(v3 <- variog(dG, max.dist=dist2, trend=~coords+I(coords[,1]^2)+I(coords[,2]^2)), xlab="(distncia)*10.000")
plot(v4 <- variog(dG, max.dist=dist2, trend="2nd"), xlab="(distncia)*10.000")	
plot(v5 <- variog(dG, max.dist=dist2, trend=~coords+I(coords[,1]^2)+I(coords[,2]^2)+ALT), xlab="(distncia)*10.000")

# Envelopes empricos
par(mfrow=c(2,3)) # Para juntar os graficos
v1.mc <- variog.mc.env(dG, obj.variog=v1); plot(v1, env=v1.mc, main="(a)", xlab="(distncia)*10.000")
v2.mc <- variog.mc.env(dG, obj.variog=v2); plot(v2, env=v2.mc, main="(b)", xlab="(distncia)*10.000")
v3.mc <- variog.mc.env(dG, obj.variog=v3); plot(v3, env=v3.mc, main="(c)", xlab="(distncia)*10.000")
v4.mc <- variog.mc.env(dG, obj.variog=v4); plot(v4, env=v4.mc, main="(d)", xlab="(distncia)*10.000")
v5.mc <- variog.mc.env(dG, obj.variog=v5); plot(v5, env=v5.mc, main="(e)", xlab="(distncia)*10.000")
# Existe alguns indicativos de dependncia espacial, confirmar com o teste posteriomente
#--------------------------------------------------------------------------------------
# Numa anlise exploratria ja foi visto que o spherical  um dos melhores ajustes (AIC)
# vamos fixar o sherical
ef1 <- eyefit(v4); ef4 # spherical (9758,25), nugget=25370
ef2 <- eyefit(v5); ef5 # spherical (9367,22), nugget=24354
ef3 <- eyefit(v6); ef6 # spherical (8206,18), nugget=25305
ef4 <- eyefit(v7); ef7 # spherical (8943,15), nugget=24146
ef5 <- eyefit(v8); ef8 # spherical (8725,15), nugget=23560
#--------------------------------------------------------------------------------------
# variofit
vf1 <- variofit(v1, ini=ef4[[1]], cov.model="spherical"); vf1
vf2 <- variofit(v2, ini=ef5[[1]], cov.model="spherical"); vf2
vf3 <- variofit(v3, ini=ef6[[1]], cov.model="spherical"); vf3
vf4 <- variofit(v4, ini=ef7[[1]], cov.model="spherical"); vf4
vf5 <- variofit(v5, ini=ef8[[1]], cov.model="spherical"); vf5

vf1 <- variofit(v1, ini=c(9758,25), nugget=25370, cov.model="spherical"); vf1
vf2 <- variofit(v2, ini=c(9367,22), nugget=24354, cov.model="spherical"); vf2
vf3 <- variofit(v3, ini=c(8206,18), nugget=25305, cov.model="spherical"); vf3
vf4 <- variofit(v4, ini=c(8943,15), nugget=24146, cov.model="spherical"); vf4
vf5 <- variofit(v5, ini=c(8725,15), nugget=23560, cov.model="spherical"); vf5

# pegar os resultados do variofit e ja ficar na ordem
paste(vf1[2],', nug=',vf1[1], sep='')
paste(vf2[2],', nug=',vf2[1], sep='')
paste(vf3[2],', nug=',vf3[1], sep='')
paste(vf4[2],', nug=',vf4[1], sep='')
paste(vf5[2],', nug=',vf5[1], sep='')

[1] "c(9868.9087288884, 20.412685588397), nug=25177.4391987498"
[2] "c(8104.40652435203, 22.6593375767967), nug=25526.4747233395"
[3] "c(7861.90120131805, 12.0138184241389), nug=24245.4036887095"
[4] "c(7003.49223117441, 11.6414097258205), nug=24522.290142747"
[5] "c(8346.98143879706, 0), nug=22539.551662372"

#--------------------------------------------------------------------------------------
## USANDO A FUNO DA GEOR 
args(likfit)
m1  <- likfit(dG, ini= vf1, cov.model="spherical", trend="1st")
m2  <- likfit(dG, ini= vf2, cov.model="spherical", trend=~coords+ALT)
m3  <- likfit(dG, ini= vf3, cov.model="spherical", trend=~coords+ I(coords[,1]^2) + I(coords[,2]^2))
m4  <- likfit(dG, ini= vf4, cov.model="spherical", trend="2nd") 
m5  <- likfit(dG, ini= vf5, cov.model="spherical", trend=~coords+ I(coords[,1]^2) + I(coords[,2]^2) + ALT)

# Outra forma para no ter que rodar os variog
m1  <- likfit(dG, ini=c(9868.9087288884, 20.412685588397), nug=25177.4391987498 , cov.model="spherical", trend="1st")
m2  <- likfit(dG, ini=c(8104.40652435203, 22.6593375767967), nug=25526.4747233395 , cov.model="spherical", trend=~coords+ALT)
m3  <- likfit(dG, ini=c(7861.90120131805, 12.0138184241389), nug=24245.4036887095 , cov.model="spherical", trend=~coords+ I(coords[,1]^2) + I(coords[,2]^2))
m4  <- likfit(dG, ini=c(7003.49223117441, 11.6414097258205), nug=24522.290142747 , cov.model="spherical", trend="2nd") 
m5  <- likfit(dG, ini=c(8346.98143879706, 0), nug=22539.551662372 , cov.model="spherical", trend=~coords+ I(coords[,1]^2) + I(coords[,2]^2) + ALT)

summary(m1)
summary(m2)
summary(m3)
summary(m4)
summary(m5)
#-------------------------------------------------------------------------------------------------------------------------------------------------------------
#ANLISE DE RESIDUOS NORMALIDADE
names(m1)
residuo1=m1$model.components$residuals
residuo2=m2$model.components$residuals
residuo3=m3$model.components$residuals
residuo4=m4$model.components$residuals
residuo5=m5$model.components$residuals
shapiro.test(residuo1)
shapiro.test(residuo2)
shapiro.test(residuo3)
shapiro.test(residuo4)
shapiro.test(residuo5)

# Box-Plot para caso de transformaes (no foi necessrio)
boxcox(dG)  
lambda <- boxcox(dG)$x[which(boxcox(dG)$y==max(boxcox(dG)$y))]
lambda

#------------------------------------------------------------------------------
# Estudo de Anisotropia
plot(variog4(dG, max.dist=dist2, trend="1st"), legend=T)
plot(variog4(dG, max.dist=dist2, trend=~coords+ALT), legend=T, xlab="distncia*10.000")
plot(variog4(dG, max.dist=dist2, trend=~coords+I(coords[,1]^2)+I(coords[,2]^2)), legend=T)
plot(variog4(dG, max.dist=dist2, trend="2nd"), legend=T)
plot(variog4(dG, max.dist=dist2, trend=~coords+I(coords[,1]^2)+I(coords[,2]^2)+ALT), legend=T)
#--------------------------------------------------------------------------------------

# TESTE ESTATISTICO
# H0: Modelo 1 explica mais que o modelo 2
est1=2*(m2$loglik - m1$loglik); est1 # estatistica
pchisq(est1,m2$npars-m1$npars,lower.tail=F) # pchisq(2*a diferena entre os log da verossimilhana, diferena entre numero de parmetros)

# H0: Modelo 1 explica mais que o modelo 3
est2=2*(m3$loglik - m1$loglik); est2 # estatistica
pchisq(est2,m3$npars-m1$npars,lower.tail=F) # pchisq(2*a diferena entre os log da verossimilhana, diferena entre numero de parmetros)

# H0: Modelo 1 explica mais que o modelo 4
est3=2*(m4$loglik - m1$loglik); est3 # estatistica
pchisq(est3,m4$npars-m1$npars,lower.tail=F) # pchisq(2*a diferena entre os log da verossimilhana, diferena entre numero de parmetros)

# H0: Modelo 1 explica mais que o modelo 5
est4=2*(m5$loglik - m1$loglik); est4 # estatistica
pchisq(est4,m5$npars-m1$npars,lower.tail=F) # pchisq(2*a diferena entre os log da verossimilhana, diferena entre numero de parmetros)

# H0: Modelo 3 explica mais que o modelo 4
est5=2*(m4$loglik - m3$loglik); est5 # estatistica
pchisq(est5,m4$npars-m3$npars,lower.tail=F) # pchisq(2*a diferena entre os log da verossimilhana, diferena entre numero de parmetros)

# H0: Modelo 3 explica mais que o modelo 5
est6=2*(m5$loglik - m3$loglik); est6 # estatistica
pchisq(est6,m5$npars-m3$npars,lower.tail=F) # pchisq(2*a diferena entre os log da verossimilhana, diferena entre numero de parmetros)

#--------------------------------------------------------------------------------------
resumo
## definindo um "grid" de predio
grid <- expand.grid(seq(6,125, 1), seq(748,845, 1))
plot(grid, pch=19, cex=0.25, col=4, xlab="longitude (x*10.000)", ylab="latitude (y*10.000)")  
points(dG, add=T)
points(dG)
#--------------------------------------------------------------------------------------
#Krigagem com os modelos

kc1 <- krige.conv(dG, loc=grid, krige=krige.control(obj.m=m2))
image(kc1, col=terrain.colors(21), x.leg=c(67,124),y.leg=c(744,751),xlab="longitude (x*10.000)", ylab="latitude (y*10.000)" )

#--------------------------------------------------------------------------------------
# Validao Cruzada
#?xvalid
VC2 <- xvalid(dG, model=m2)
VC4 <- xvalid(dG, model=m4)
par(mfrow=c(2,2)) # Para juntar os graficos
plot(VC2)
plot(VC4)
lmVC2 <- lm(VC2$data~VC2$predicted); lmVC2
AIC(lmVC2);cor(VC2$data,VC2$predicted)

#--------------------------------------------------------------------------------------



